@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetIotSecuritySolutionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property solutionName The name of the IoT Security solution.
 */
public data class GetIotSecuritySolutionPlainArgs(
    public val resourceGroupName: String,
    public val solutionName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetIotSecuritySolutionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetIotSecuritySolutionPlainArgs =
        com.pulumi.azurenative.security.inputs.GetIotSecuritySolutionPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .solutionName(solutionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIotSecuritySolutionPlainArgs].
 */
@PulumiTagMarker
public class GetIotSecuritySolutionPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var solutionName: String? = null

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("ydjfqcqlidynaplr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the IoT Security solution.
     */
    @JvmName("rwbgyfpgthlykind")
    public suspend fun solutionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.solutionName = mapped
    }

    internal fun build(): GetIotSecuritySolutionPlainArgs = GetIotSecuritySolutionPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        solutionName = solutionName ?: throw PulumiNullFieldException("solutionName"),
    )
}
