@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetPricingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property pricingName name of the pricing configuration
 * @property scopeId The scope id of the pricing. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or a specific resource (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}) - Supported resources are (VirtualMachines)
 */
public data class GetPricingPlainArgs(
    public val pricingName: String,
    public val scopeId: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetPricingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetPricingPlainArgs =
        com.pulumi.azurenative.security.inputs.GetPricingPlainArgs.builder()
            .pricingName(pricingName.let({ args0 -> args0 }))
            .scopeId(scopeId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPricingPlainArgs].
 */
@PulumiTagMarker
public class GetPricingPlainArgsBuilder internal constructor() {
    private var pricingName: String? = null

    private var scopeId: String? = null

    /**
     * @param value name of the pricing configuration
     */
    @JvmName("xnalmcffuahmmepl")
    public suspend fun pricingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pricingName = mapped
    }

    /**
     * @param value The scope id of the pricing. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or a specific resource (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}) - Supported resources are (VirtualMachines)
     */
    @JvmName("hskkguanecsdiaxh")
    public suspend fun scopeId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scopeId = mapped
    }

    internal fun build(): GetPricingPlainArgs = GetPricingPlainArgs(
        pricingName = pricingName ?: throw PulumiNullFieldException("pricingName"),
        scopeId = scopeId ?: throw PulumiNullFieldException("scopeId"),
    )
}
