@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetSqlVulnerabilityAssessmentBaselineRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceId The identifier of the resource.
 * @property ruleId The rule Id.
 * @property workspaceId The workspace Id.
 */
public data class GetSqlVulnerabilityAssessmentBaselineRulePlainArgs(
    public val resourceId: String,
    public val ruleId: String,
    public val workspaceId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetSqlVulnerabilityAssessmentBaselineRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetSqlVulnerabilityAssessmentBaselineRulePlainArgs =
        com.pulumi.azurenative.security.inputs.GetSqlVulnerabilityAssessmentBaselineRulePlainArgs.builder()
            .resourceId(resourceId.let({ args0 -> args0 }))
            .ruleId(ruleId.let({ args0 -> args0 }))
            .workspaceId(workspaceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlVulnerabilityAssessmentBaselineRulePlainArgs].
 */
@PulumiTagMarker
public class GetSqlVulnerabilityAssessmentBaselineRulePlainArgsBuilder internal constructor() {
    private var resourceId: String? = null

    private var ruleId: String? = null

    private var workspaceId: String? = null

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("vqnnvnkyudrcqqwx")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    /**
     * @param value The rule Id.
     */
    @JvmName("ivafalpaehxkoyaw")
    public suspend fun ruleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleId = mapped
    }

    /**
     * @param value The workspace Id.
     */
    @JvmName("gdfcwswndukvqcot")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceId = mapped
    }

    internal fun build(): GetSqlVulnerabilityAssessmentBaselineRulePlainArgs =
        GetSqlVulnerabilityAssessmentBaselineRulePlainArgs(
            resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
            ruleId = ruleId ?: throw PulumiNullFieldException("ruleId"),
            workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
        )
}
