@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GithubScopeEnvironmentDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The github scope connector's environment data
 * @property environmentType The type of the environment data.
 * Expected value is 'GithubScope'.
 */
public data class GithubScopeEnvironmentDataArgs(
    public val environmentType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GithubScopeEnvironmentDataArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GithubScopeEnvironmentDataArgs =
        com.pulumi.azurenative.security.inputs.GithubScopeEnvironmentDataArgs.builder()
            .environmentType(environmentType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GithubScopeEnvironmentDataArgs].
 */
@PulumiTagMarker
public class GithubScopeEnvironmentDataArgsBuilder internal constructor() {
    private var environmentType: Output<String>? = null

    /**
     * @param value The type of the environment data.
     * Expected value is 'GithubScope'.
     */
    @JvmName("qwwydobnuhxjught")
    public suspend fun environmentType(`value`: Output<String>) {
        this.environmentType = value
    }

    /**
     * @param value The type of the environment data.
     * Expected value is 'GithubScope'.
     */
    @JvmName("birsqqmomavkpkgl")
    public suspend fun environmentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    internal fun build(): GithubScopeEnvironmentDataArgs = GithubScopeEnvironmentDataArgs(
        environmentType = environmentType ?: throw PulumiNullFieldException("environmentType"),
    )
}
