@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.JitNetworkAccessPolicyVirtualMachineArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property id Resource ID of the virtual machine that is linked to this policy
 * @property ports Port configurations for the virtual machine
 * @property publicIpAddress Public IP address of the Azure Firewall that is linked to this policy, if applicable
 */
public data class JitNetworkAccessPolicyVirtualMachineArgs(
    public val id: Output<String>,
    public val ports: Output<List<JitNetworkAccessPortRuleArgs>>,
    public val publicIpAddress: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.JitNetworkAccessPolicyVirtualMachineArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.JitNetworkAccessPolicyVirtualMachineArgs =
        com.pulumi.azurenative.security.inputs.JitNetworkAccessPolicyVirtualMachineArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .ports(ports.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .publicIpAddress(publicIpAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JitNetworkAccessPolicyVirtualMachineArgs].
 */
@PulumiTagMarker
public class JitNetworkAccessPolicyVirtualMachineArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var ports: Output<List<JitNetworkAccessPortRuleArgs>>? = null

    private var publicIpAddress: Output<String>? = null

    /**
     * @param value Resource ID of the virtual machine that is linked to this policy
     */
    @JvmName("xgpvoddoyvaijcnf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Port configurations for the virtual machine
     */
    @JvmName("ydxorkwvagpttkuw")
    public suspend fun ports(`value`: Output<List<JitNetworkAccessPortRuleArgs>>) {
        this.ports = value
    }

    @JvmName("pyrincwnjrgfvmkr")
    public suspend fun ports(vararg values: Output<JitNetworkAccessPortRuleArgs>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values Port configurations for the virtual machine
     */
    @JvmName("ilyxfyashpyetmvp")
    public suspend fun ports(values: List<Output<JitNetworkAccessPortRuleArgs>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value Public IP address of the Azure Firewall that is linked to this policy, if applicable
     */
    @JvmName("ypdjohiijccwgqvs")
    public suspend fun publicIpAddress(`value`: Output<String>) {
        this.publicIpAddress = value
    }

    /**
     * @param value Resource ID of the virtual machine that is linked to this policy
     */
    @JvmName("isbrvxfqpqubmpkc")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Port configurations for the virtual machine
     */
    @JvmName("qnrujiqhmeqggkdt")
    public suspend fun ports(`value`: List<JitNetworkAccessPortRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param argument Port configurations for the virtual machine
     */
    @JvmName("mkjkdkqdawnbsvsl")
    public suspend fun ports(argument: List<suspend JitNetworkAccessPortRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JitNetworkAccessPortRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument Port configurations for the virtual machine
     */
    @JvmName("ghdcohifcqqhmcnu")
    public suspend fun ports(vararg argument: suspend JitNetworkAccessPortRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            JitNetworkAccessPortRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument Port configurations for the virtual machine
     */
    @JvmName("voqslhyldlkjstby")
    public suspend fun ports(argument: suspend JitNetworkAccessPortRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            JitNetworkAccessPortRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param values Port configurations for the virtual machine
     */
    @JvmName("rcvoxjylnsqjixgn")
    public suspend fun ports(vararg values: JitNetworkAccessPortRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param value Public IP address of the Azure Firewall that is linked to this policy, if applicable
     */
    @JvmName("rxtqpxibxuvghult")
    public suspend fun publicIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpAddress = mapped
    }

    internal fun build(): JitNetworkAccessPolicyVirtualMachineArgs =
        JitNetworkAccessPolicyVirtualMachineArgs(
            id = id ?: throw PulumiNullFieldException("id"),
            ports = ports ?: throw PulumiNullFieldException("ports"),
            publicIpAddress = publicIpAddress,
        )
}
