@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.JitNetworkAccessPortRuleArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.Protocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowedSourceAddressPrefix Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
 * @property allowedSourceAddressPrefixes Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
 * @property maxRequestAccessDuration Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
 * @property number
 * @property protocol
 */
public data class JitNetworkAccessPortRuleArgs(
    public val allowedSourceAddressPrefix: Output<String>? = null,
    public val allowedSourceAddressPrefixes: Output<List<String>>? = null,
    public val maxRequestAccessDuration: Output<String>,
    public val number: Output<Int>,
    public val protocol: Output<Either<String, Protocol>>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.JitNetworkAccessPortRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.JitNetworkAccessPortRuleArgs =
        com.pulumi.azurenative.security.inputs.JitNetworkAccessPortRuleArgs.builder()
            .allowedSourceAddressPrefix(allowedSourceAddressPrefix?.applyValue({ args0 -> args0 }))
            .allowedSourceAddressPrefixes(
                allowedSourceAddressPrefixes?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .maxRequestAccessDuration(maxRequestAccessDuration.applyValue({ args0 -> args0 }))
            .number(number.applyValue({ args0 -> args0 }))
            .protocol(
                protocol.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [JitNetworkAccessPortRuleArgs].
 */
@PulumiTagMarker
public class JitNetworkAccessPortRuleArgsBuilder internal constructor() {
    private var allowedSourceAddressPrefix: Output<String>? = null

    private var allowedSourceAddressPrefixes: Output<List<String>>? = null

    private var maxRequestAccessDuration: Output<String>? = null

    private var number: Output<Int>? = null

    private var protocol: Output<Either<String, Protocol>>? = null

    /**
     * @param value Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
     */
    @JvmName("xwmfrsmurtqoyqat")
    public suspend fun allowedSourceAddressPrefix(`value`: Output<String>) {
        this.allowedSourceAddressPrefix = value
    }

    /**
     * @param value Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
     */
    @JvmName("hvjmlwhxjmqvfrnx")
    public suspend fun allowedSourceAddressPrefixes(`value`: Output<List<String>>) {
        this.allowedSourceAddressPrefixes = value
    }

    @JvmName("ybdagxoxxojdgymu")
    public suspend fun allowedSourceAddressPrefixes(vararg values: Output<String>) {
        this.allowedSourceAddressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
     */
    @JvmName("gprnjwgqqgcpmiig")
    public suspend fun allowedSourceAddressPrefixes(values: List<Output<String>>) {
        this.allowedSourceAddressPrefixes = Output.all(values)
    }

    /**
     * @param value Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
     */
    @JvmName("hfsateuoqxjdnidd")
    public suspend fun maxRequestAccessDuration(`value`: Output<String>) {
        this.maxRequestAccessDuration = value
    }

    /**
     * @param value
     */
    @JvmName("acnhhdrmxgjlkeaa")
    public suspend fun number(`value`: Output<Int>) {
        this.number = value
    }

    /**
     * @param value
     */
    @JvmName("twpuudcdxxehuped")
    public suspend fun protocol(`value`: Output<Either<String, Protocol>>) {
        this.protocol = value
    }

    /**
     * @param value Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
     */
    @JvmName("rdivdkdvwjurqppl")
    public suspend fun allowedSourceAddressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedSourceAddressPrefix = mapped
    }

    /**
     * @param value Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
     */
    @JvmName("nxalickciienligo")
    public suspend fun allowedSourceAddressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedSourceAddressPrefixes = mapped
    }

    /**
     * @param values Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
     */
    @JvmName("dsewqnchyfqaamib")
    public suspend fun allowedSourceAddressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedSourceAddressPrefixes = mapped
    }

    /**
     * @param value Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
     */
    @JvmName("offgmcwojusdpqfu")
    public suspend fun maxRequestAccessDuration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxRequestAccessDuration = mapped
    }

    /**
     * @param value
     */
    @JvmName("ggpfctbbgfcntetg")
    public suspend fun number(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.number = mapped
    }

    /**
     * @param value
     */
    @JvmName("pphxbajaagurmlbm")
    public suspend fun protocol(`value`: Either<String, Protocol>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value
     */
    @JvmName("lkmvppnqyqltytie")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Protocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value
     */
    @JvmName("jusqvwoqvtmlnpqp")
    public fun protocol(`value`: Protocol) {
        val toBeMapped = Either.ofRight<String, Protocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): JitNetworkAccessPortRuleArgs = JitNetworkAccessPortRuleArgs(
        allowedSourceAddressPrefix = allowedSourceAddressPrefix,
        allowedSourceAddressPrefixes = allowedSourceAddressPrefixes,
        maxRequestAccessDuration = maxRequestAccessDuration ?: throw
            PulumiNullFieldException("maxRequestAccessDuration"),
        number = number ?: throw PulumiNullFieldException("number"),
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
    )
}
