@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.OnPremiseSqlResourceDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of the On Premise Sql resource that was assessed
 * @property databaseName The Sql database name installed on the machine
 * @property machineName The name of the machine
 * @property serverName The Sql server name installed on the machine
 * @property source The platform where the assessed resource resides
 * Expected value is 'OnPremiseSql'.
 * @property sourceComputerId The oms agent Id installed on the machine
 * @property vmuuid The unique Id of the machine
 * @property workspaceId Azure resource Id of the workspace the machine is attached to
 */
public data class OnPremiseSqlResourceDetailsArgs(
    public val databaseName: Output<String>,
    public val machineName: Output<String>,
    public val serverName: Output<String>,
    public val source: Output<String>,
    public val sourceComputerId: Output<String>,
    public val vmuuid: Output<String>,
    public val workspaceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.OnPremiseSqlResourceDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.OnPremiseSqlResourceDetailsArgs =
        com.pulumi.azurenative.security.inputs.OnPremiseSqlResourceDetailsArgs.builder()
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .machineName(machineName.applyValue({ args0 -> args0 }))
            .serverName(serverName.applyValue({ args0 -> args0 }))
            .source(source.applyValue({ args0 -> args0 }))
            .sourceComputerId(sourceComputerId.applyValue({ args0 -> args0 }))
            .vmuuid(vmuuid.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OnPremiseSqlResourceDetailsArgs].
 */
@PulumiTagMarker
public class OnPremiseSqlResourceDetailsArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var machineName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var source: Output<String>? = null

    private var sourceComputerId: Output<String>? = null

    private var vmuuid: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value The Sql database name installed on the machine
     */
    @JvmName("opdiidxsgurcuskh")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the machine
     */
    @JvmName("hxyqciwxkodjxneh")
    public suspend fun machineName(`value`: Output<String>) {
        this.machineName = value
    }

    /**
     * @param value The Sql server name installed on the machine
     */
    @JvmName("nbalujkfdhlvspmj")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The platform where the assessed resource resides
     * Expected value is 'OnPremiseSql'.
     */
    @JvmName("rmlmnncrmwpqwnuo")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The oms agent Id installed on the machine
     */
    @JvmName("lrhakuacrobqbpux")
    public suspend fun sourceComputerId(`value`: Output<String>) {
        this.sourceComputerId = value
    }

    /**
     * @param value The unique Id of the machine
     */
    @JvmName("rpgklvsdxabeebbq")
    public suspend fun vmuuid(`value`: Output<String>) {
        this.vmuuid = value
    }

    /**
     * @param value Azure resource Id of the workspace the machine is attached to
     */
    @JvmName("orgdxdqjqtvgbqfc")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The Sql database name installed on the machine
     */
    @JvmName("jqmsnynmifdebces")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the machine
     */
    @JvmName("eyvmrxtjwmwfbqvd")
    public suspend fun machineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.machineName = mapped
    }

    /**
     * @param value The Sql server name installed on the machine
     */
    @JvmName("epfvgmcbtmfwqqyd")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The platform where the assessed resource resides
     * Expected value is 'OnPremiseSql'.
     */
    @JvmName("ivlorjbwaipfndqg")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The oms agent Id installed on the machine
     */
    @JvmName("klnpwgliodrtxbfc")
    public suspend fun sourceComputerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceComputerId = mapped
    }

    /**
     * @param value The unique Id of the machine
     */
    @JvmName("vihdspwltjvueujo")
    public suspend fun vmuuid(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmuuid = mapped
    }

    /**
     * @param value Azure resource Id of the workspace the machine is attached to
     */
    @JvmName("cmwrjdkhblapuric")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): OnPremiseSqlResourceDetailsArgs = OnPremiseSqlResourceDetailsArgs(
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        machineName = machineName ?: throw PulumiNullFieldException("machineName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        source = source ?: throw PulumiNullFieldException("source"),
        sourceComputerId = sourceComputerId ?: throw PulumiNullFieldException("sourceComputerId"),
        vmuuid = vmuuid ?: throw PulumiNullFieldException("vmuuid"),
        workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
    )
}
