@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.PathRecommendationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents a path that is recommended to be allowed and its properties
 * @property action The recommendation action of the machine or rule
 * @property common Whether the application is commonly run on the machine
 * @property configurationStatus The configuration status of the machines group or machine or rule
 * @property fileType The type of the file (for Linux files - Executable is used)
 * @property path The full path of the file, or an identifier of the application
 * @property publisherInfo Represents the publisher information of a process/rule
 * @property type The type of the rule to be allowed
 * @property userSids
 * @property usernames
 */
public data class PathRecommendationArgs(
    public val action: Output<String>? = null,
    public val common: Output<Boolean>? = null,
    public val configurationStatus: Output<String>? = null,
    public val fileType: Output<String>? = null,
    public val path: Output<String>? = null,
    public val publisherInfo: Output<PublisherInfoArgs>? = null,
    public val type: Output<String>? = null,
    public val userSids: Output<List<String>>? = null,
    public val usernames: Output<List<UserRecommendationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.PathRecommendationArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.PathRecommendationArgs =
        com.pulumi.azurenative.security.inputs.PathRecommendationArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .common(common?.applyValue({ args0 -> args0 }))
            .configurationStatus(configurationStatus?.applyValue({ args0 -> args0 }))
            .fileType(fileType?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .publisherInfo(publisherInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 }))
            .userSids(userSids?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .usernames(
                usernames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PathRecommendationArgs].
 */
@PulumiTagMarker
public class PathRecommendationArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var common: Output<Boolean>? = null

    private var configurationStatus: Output<String>? = null

    private var fileType: Output<String>? = null

    private var path: Output<String>? = null

    private var publisherInfo: Output<PublisherInfoArgs>? = null

    private var type: Output<String>? = null

    private var userSids: Output<List<String>>? = null

    private var usernames: Output<List<UserRecommendationArgs>>? = null

    /**
     * @param value The recommendation action of the machine or rule
     */
    @JvmName("idnfjqmjoqcmcbsk")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value Whether the application is commonly run on the machine
     */
    @JvmName("nlivftikbppmfjcx")
    public suspend fun common(`value`: Output<Boolean>) {
        this.common = value
    }

    /**
     * @param value The configuration status of the machines group or machine or rule
     */
    @JvmName("hawufodeaerhiytu")
    public suspend fun configurationStatus(`value`: Output<String>) {
        this.configurationStatus = value
    }

    /**
     * @param value The type of the file (for Linux files - Executable is used)
     */
    @JvmName("kcipwntbekaslspl")
    public suspend fun fileType(`value`: Output<String>) {
        this.fileType = value
    }

    /**
     * @param value The full path of the file, or an identifier of the application
     */
    @JvmName("tjeolmlefivvjmfo")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Represents the publisher information of a process/rule
     */
    @JvmName("eqofsnvfgwoydmvv")
    public suspend fun publisherInfo(`value`: Output<PublisherInfoArgs>) {
        this.publisherInfo = value
    }

    /**
     * @param value The type of the rule to be allowed
     */
    @JvmName("jxbtvpocqsnnkogr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("qrxewgpqxrirnoee")
    public suspend fun userSids(`value`: Output<List<String>>) {
        this.userSids = value
    }

    @JvmName("sxxhgvxyajkrdkir")
    public suspend fun userSids(vararg values: Output<String>) {
        this.userSids = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("bsulbiefprkikbnp")
    public suspend fun userSids(values: List<Output<String>>) {
        this.userSids = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("cwyhhieotldoqcth")
    public suspend fun usernames(`value`: Output<List<UserRecommendationArgs>>) {
        this.usernames = value
    }

    @JvmName("ukkaoevcuqlkatmx")
    public suspend fun usernames(vararg values: Output<UserRecommendationArgs>) {
        this.usernames = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vrpfhmdtoxkfxogg")
    public suspend fun usernames(values: List<Output<UserRecommendationArgs>>) {
        this.usernames = Output.all(values)
    }

    /**
     * @param value The recommendation action of the machine or rule
     */
    @JvmName("rtdbourxenbsitjp")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Whether the application is commonly run on the machine
     */
    @JvmName("xodohiennkaflydi")
    public suspend fun common(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.common = mapped
    }

    /**
     * @param value The configuration status of the machines group or machine or rule
     */
    @JvmName("tralkoknlpgigsme")
    public suspend fun configurationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationStatus = mapped
    }

    /**
     * @param value The type of the file (for Linux files - Executable is used)
     */
    @JvmName("xrkgsfmsuxscbpla")
    public suspend fun fileType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileType = mapped
    }

    /**
     * @param value The full path of the file, or an identifier of the application
     */
    @JvmName("kgcknkmosvnuaobf")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Represents the publisher information of a process/rule
     */
    @JvmName("ppufercrosfjaipi")
    public suspend fun publisherInfo(`value`: PublisherInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherInfo = mapped
    }

    /**
     * @param argument Represents the publisher information of a process/rule
     */
    @JvmName("ftvxdwkgsagekfgo")
    public suspend fun publisherInfo(argument: suspend PublisherInfoArgsBuilder.() -> Unit) {
        val toBeMapped = PublisherInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publisherInfo = mapped
    }

    /**
     * @param value The type of the rule to be allowed
     */
    @JvmName("hlxghngldechboql")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("jswrdhvrljkpoeta")
    public suspend fun userSids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userSids = mapped
    }

    /**
     * @param values
     */
    @JvmName("xqwjeumfemgiiwrp")
    public suspend fun userSids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userSids = mapped
    }

    /**
     * @param value
     */
    @JvmName("fscamvllftqbsrrt")
    public suspend fun usernames(`value`: List<UserRecommendationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernames = mapped
    }

    /**
     * @param argument
     */
    @JvmName("eadyiojrsgsctyhh")
    public suspend fun usernames(argument: List<suspend UserRecommendationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserRecommendationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.usernames = mapped
    }

    /**
     * @param argument
     */
    @JvmName("adllqgwxhggrwsfk")
    public suspend fun usernames(vararg argument: suspend UserRecommendationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserRecommendationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.usernames = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qosoabvracyxurrr")
    public suspend fun usernames(argument: suspend UserRecommendationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserRecommendationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.usernames = mapped
    }

    /**
     * @param values
     */
    @JvmName("kyovdnpuecfvadfk")
    public suspend fun usernames(vararg values: UserRecommendationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usernames = mapped
    }

    internal fun build(): PathRecommendationArgs = PathRecommendationArgs(
        action = action,
        common = common,
        configurationStatus = configurationStatus,
        fileType = fileType,
        path = path,
        publisherInfo = publisherInfo,
        type = type,
        userSids = userSids,
        usernames = usernames,
    )
}
