@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.SecurityAssessmentMetadataPropertiesArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.AssessmentType
import com.pulumi.azurenative.security.kotlin.enums.Categories
import com.pulumi.azurenative.security.kotlin.enums.ImplementationEffort
import com.pulumi.azurenative.security.kotlin.enums.Severity
import com.pulumi.azurenative.security.kotlin.enums.Threats
import com.pulumi.azurenative.security.kotlin.enums.UserImpact
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes properties of an assessment metadata.
 * @property assessmentType BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
 * @property categories
 * @property description Human readable description of the assessment
 * @property displayName User friendly display name of the assessment
 * @property implementationEffort The implementation effort required to remediate this assessment
 * @property partnerData Describes the partner that created the assessment
 * @property preview True if this assessment is in preview release status
 * @property remediationDescription Human readable description of what you should do to mitigate this security issue
 * @property severity The severity level of the assessment
 * @property threats
 * @property userImpact The user impact of the assessment
 */
public data class SecurityAssessmentMetadataPropertiesArgs(
    public val assessmentType: Output<Either<String, AssessmentType>>,
    public val categories: Output<List<Either<String, Categories>>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>,
    public val implementationEffort: Output<Either<String, ImplementationEffort>>? = null,
    public val partnerData: Output<SecurityAssessmentMetadataPartnerDataArgs>? = null,
    public val preview: Output<Boolean>? = null,
    public val remediationDescription: Output<String>? = null,
    public val severity: Output<Either<String, Severity>>,
    public val threats: Output<List<Either<String, Threats>>>? = null,
    public val userImpact: Output<Either<String, UserImpact>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.SecurityAssessmentMetadataPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.SecurityAssessmentMetadataPropertiesArgs =
        com.pulumi.azurenative.security.inputs.SecurityAssessmentMetadataPropertiesArgs.builder()
            .assessmentType(
                assessmentType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .categories(
                categories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName.applyValue({ args0 -> args0 }))
            .implementationEffort(
                implementationEffort?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .partnerData(partnerData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preview(preview?.applyValue({ args0 -> args0 }))
            .remediationDescription(remediationDescription?.applyValue({ args0 -> args0 }))
            .severity(
                severity.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .threats(
                threats?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .userImpact(
                userImpact?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SecurityAssessmentMetadataPropertiesArgs].
 */
@PulumiTagMarker
public class SecurityAssessmentMetadataPropertiesArgsBuilder internal constructor() {
    private var assessmentType: Output<Either<String, AssessmentType>>? = null

    private var categories: Output<List<Either<String, Categories>>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var implementationEffort: Output<Either<String, ImplementationEffort>>? = null

    private var partnerData: Output<SecurityAssessmentMetadataPartnerDataArgs>? = null

    private var preview: Output<Boolean>? = null

    private var remediationDescription: Output<String>? = null

    private var severity: Output<Either<String, Severity>>? = null

    private var threats: Output<List<Either<String, Threats>>>? = null

    private var userImpact: Output<Either<String, UserImpact>>? = null

    /**
     * @param value BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
     */
    @JvmName("hhgacubaphbsjcxl")
    public suspend fun assessmentType(`value`: Output<Either<String, AssessmentType>>) {
        this.assessmentType = value
    }

    /**
     * @param value
     */
    @JvmName("sbawrhixlywrmypo")
    public suspend fun categories(`value`: Output<List<Either<String, Categories>>>) {
        this.categories = value
    }

    @JvmName("qburkxlugbtttkbs")
    public suspend fun categories(vararg values: Output<Either<String, Categories>>) {
        this.categories = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ncstgvqanbnkogjg")
    public suspend fun categories(values: List<Output<Either<String, Categories>>>) {
        this.categories = Output.all(values)
    }

    /**
     * @param value Human readable description of the assessment
     */
    @JvmName("jpdegbptvgvtonia")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value User friendly display name of the assessment
     */
    @JvmName("ywhxmqwnfxsvrdho")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The implementation effort required to remediate this assessment
     */
    @JvmName("qeusxvmysvfjrfpu")
    public suspend fun implementationEffort(`value`: Output<Either<String, ImplementationEffort>>) {
        this.implementationEffort = value
    }

    /**
     * @param value Describes the partner that created the assessment
     */
    @JvmName("bqwkeeplwmmftvih")
    public suspend fun partnerData(`value`: Output<SecurityAssessmentMetadataPartnerDataArgs>) {
        this.partnerData = value
    }

    /**
     * @param value True if this assessment is in preview release status
     */
    @JvmName("krpnxrocdexhidyy")
    public suspend fun preview(`value`: Output<Boolean>) {
        this.preview = value
    }

    /**
     * @param value Human readable description of what you should do to mitigate this security issue
     */
    @JvmName("vcymngwirmnwbnpw")
    public suspend fun remediationDescription(`value`: Output<String>) {
        this.remediationDescription = value
    }

    /**
     * @param value The severity level of the assessment
     */
    @JvmName("djpinnewubljxgba")
    public suspend fun severity(`value`: Output<Either<String, Severity>>) {
        this.severity = value
    }

    /**
     * @param value
     */
    @JvmName("rynqkpvgncsyvxxd")
    public suspend fun threats(`value`: Output<List<Either<String, Threats>>>) {
        this.threats = value
    }

    @JvmName("rpwyuyebrjjauyca")
    public suspend fun threats(vararg values: Output<Either<String, Threats>>) {
        this.threats = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("jsuucqjqtygftvet")
    public suspend fun threats(values: List<Output<Either<String, Threats>>>) {
        this.threats = Output.all(values)
    }

    /**
     * @param value The user impact of the assessment
     */
    @JvmName("kbvryisfepcpfrny")
    public suspend fun userImpact(`value`: Output<Either<String, UserImpact>>) {
        this.userImpact = value
    }

    /**
     * @param value BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
     */
    @JvmName("kkmrvbigegelsusa")
    public suspend fun assessmentType(`value`: Either<String, AssessmentType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
     */
    @JvmName("hghcrilvvkwynjuv")
    public fun assessmentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
     */
    @JvmName("msargudpaovajwxj")
    public fun assessmentType(`value`: AssessmentType) {
        val toBeMapped = Either.ofRight<String, AssessmentType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assessmentType = mapped
    }

    /**
     * @param value
     */
    @JvmName("tpctourrmitlrvgf")
    public suspend fun categories(`value`: List<Either<String, Categories>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param values
     */
    @JvmName("knykbcqcevsxpdok")
    public suspend fun categories(vararg values: Either<String, Categories>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param value Human readable description of the assessment
     */
    @JvmName("paukeusftfsyqoqj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value User friendly display name of the assessment
     */
    @JvmName("tcnfexhqeskctasx")
    public suspend fun displayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The implementation effort required to remediate this assessment
     */
    @JvmName("ytbumjrxdqnjehpy")
    public suspend fun implementationEffort(`value`: Either<String, ImplementationEffort>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.implementationEffort = mapped
    }

    /**
     * @param value The implementation effort required to remediate this assessment
     */
    @JvmName("ebgvgfraicgyhyps")
    public fun implementationEffort(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ImplementationEffort>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.implementationEffort = mapped
    }

    /**
     * @param value The implementation effort required to remediate this assessment
     */
    @JvmName("fpdbcvvdmgwlekse")
    public fun implementationEffort(`value`: ImplementationEffort) {
        val toBeMapped = Either.ofRight<String, ImplementationEffort>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.implementationEffort = mapped
    }

    /**
     * @param value Describes the partner that created the assessment
     */
    @JvmName("oyoykfvwuatltldp")
    public suspend fun partnerData(`value`: SecurityAssessmentMetadataPartnerDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerData = mapped
    }

    /**
     * @param argument Describes the partner that created the assessment
     */
    @JvmName("dtjufdywmudamerm")
    public suspend fun partnerData(argument: suspend SecurityAssessmentMetadataPartnerDataArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityAssessmentMetadataPartnerDataArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.partnerData = mapped
    }

    /**
     * @param value True if this assessment is in preview release status
     */
    @JvmName("vxkudwevhubwodrl")
    public suspend fun preview(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preview = mapped
    }

    /**
     * @param value Human readable description of what you should do to mitigate this security issue
     */
    @JvmName("axrphcgfwpelwdnn")
    public suspend fun remediationDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remediationDescription = mapped
    }

    /**
     * @param value The severity level of the assessment
     */
    @JvmName("amasxvxaqcdlreww")
    public suspend fun severity(`value`: Either<String, Severity>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity level of the assessment
     */
    @JvmName("pskgkkpklmdbhqef")
    public fun severity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Severity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The severity level of the assessment
     */
    @JvmName("mnvatvvsuxpnyqit")
    public fun severity(`value`: Severity) {
        val toBeMapped = Either.ofRight<String, Severity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value
     */
    @JvmName("nllnrrxkxtrlajih")
    public suspend fun threats(`value`: List<Either<String, Threats>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threats = mapped
    }

    /**
     * @param values
     */
    @JvmName("yfdqcrfrgdxtiumn")
    public suspend fun threats(vararg values: Either<String, Threats>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threats = mapped
    }

    /**
     * @param value The user impact of the assessment
     */
    @JvmName("lufukiyrwnkpygyp")
    public suspend fun userImpact(`value`: Either<String, UserImpact>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userImpact = mapped
    }

    /**
     * @param value The user impact of the assessment
     */
    @JvmName("bagwasyrxotqqduw")
    public fun userImpact(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UserImpact>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userImpact = mapped
    }

    /**
     * @param value The user impact of the assessment
     */
    @JvmName("npcfqqlwffbsppit")
    public fun userImpact(`value`: UserImpact) {
        val toBeMapped = Either.ofRight<String, UserImpact>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userImpact = mapped
    }

    internal fun build(): SecurityAssessmentMetadataPropertiesArgs =
        SecurityAssessmentMetadataPropertiesArgs(
            assessmentType = assessmentType ?: throw PulumiNullFieldException("assessmentType"),
            categories = categories,
            description = description,
            displayName = displayName ?: throw PulumiNullFieldException("displayName"),
            implementationEffort = implementationEffort,
            partnerData = partnerData,
            preview = preview,
            remediationDescription = remediationDescription,
            severity = severity ?: throw PulumiNullFieldException("severity"),
            threats = threats,
            userImpact = userImpact,
        )
}
