@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.SecurityAssessmentPartnerDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Data regarding 3rd party partner integration
 * @property partnerName Name of the company of the partner
 * @property secret secret to authenticate the partner - write only
 */
public data class SecurityAssessmentPartnerDataArgs(
    public val partnerName: Output<String>,
    public val secret: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.SecurityAssessmentPartnerDataArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.SecurityAssessmentPartnerDataArgs =
        com.pulumi.azurenative.security.inputs.SecurityAssessmentPartnerDataArgs.builder()
            .partnerName(partnerName.applyValue({ args0 -> args0 }))
            .secret(secret.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityAssessmentPartnerDataArgs].
 */
@PulumiTagMarker
public class SecurityAssessmentPartnerDataArgsBuilder internal constructor() {
    private var partnerName: Output<String>? = null

    private var secret: Output<String>? = null

    /**
     * @param value Name of the company of the partner
     */
    @JvmName("rcprjgumrxyihgns")
    public suspend fun partnerName(`value`: Output<String>) {
        this.partnerName = value
    }

    /**
     * @param value secret to authenticate the partner - write only
     */
    @JvmName("wvjfxwallyrvvlrl")
    public suspend fun secret(`value`: Output<String>) {
        this.secret = value
    }

    /**
     * @param value Name of the company of the partner
     */
    @JvmName("gxkyltnjrawyyprk")
    public suspend fun partnerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partnerName = mapped
    }

    /**
     * @param value secret to authenticate the partner - write only
     */
    @JvmName("ywhxxiybjplipmro")
    public suspend fun secret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secret = mapped
    }

    internal fun build(): SecurityAssessmentPartnerDataArgs = SecurityAssessmentPartnerDataArgs(
        partnerName = partnerName ?: throw PulumiNullFieldException("partnerName"),
        secret = secret ?: throw PulumiNullFieldException("secret"),
    )
}
