@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.TimeWindowCustomAlertRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A custom alert rule that checks if the number of activities (depends on the custom alert type) in a time window is within the given range.
 * @property isEnabled Status of the custom alert.
 * @property maxThreshold The maximum threshold.
 * @property minThreshold The minimum threshold.
 * @property ruleType The type of the custom alert rule.
 * Expected value is 'TimeWindowCustomAlertRule'.
 * @property timeWindowSize The time window size in iso8601 format.
 */
public data class TimeWindowCustomAlertRuleArgs(
    public val isEnabled: Output<Boolean>,
    public val maxThreshold: Output<Int>,
    public val minThreshold: Output<Int>,
    public val ruleType: Output<String>,
    public val timeWindowSize: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.TimeWindowCustomAlertRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.TimeWindowCustomAlertRuleArgs =
        com.pulumi.azurenative.security.inputs.TimeWindowCustomAlertRuleArgs.builder()
            .isEnabled(isEnabled.applyValue({ args0 -> args0 }))
            .maxThreshold(maxThreshold.applyValue({ args0 -> args0 }))
            .minThreshold(minThreshold.applyValue({ args0 -> args0 }))
            .ruleType(ruleType.applyValue({ args0 -> args0 }))
            .timeWindowSize(timeWindowSize.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TimeWindowCustomAlertRuleArgs].
 */
@PulumiTagMarker
public class TimeWindowCustomAlertRuleArgsBuilder internal constructor() {
    private var isEnabled: Output<Boolean>? = null

    private var maxThreshold: Output<Int>? = null

    private var minThreshold: Output<Int>? = null

    private var ruleType: Output<String>? = null

    private var timeWindowSize: Output<String>? = null

    /**
     * @param value Status of the custom alert.
     */
    @JvmName("muugphdkxpxkvrvd")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The maximum threshold.
     */
    @JvmName("tgppxvfjerouvemp")
    public suspend fun maxThreshold(`value`: Output<Int>) {
        this.maxThreshold = value
    }

    /**
     * @param value The minimum threshold.
     */
    @JvmName("ciafbjvxjoxcwlmp")
    public suspend fun minThreshold(`value`: Output<Int>) {
        this.minThreshold = value
    }

    /**
     * @param value The type of the custom alert rule.
     * Expected value is 'TimeWindowCustomAlertRule'.
     */
    @JvmName("dydodqerbqdfwngi")
    public suspend fun ruleType(`value`: Output<String>) {
        this.ruleType = value
    }

    /**
     * @param value The time window size in iso8601 format.
     */
    @JvmName("fhjvcdlgyfplloar")
    public suspend fun timeWindowSize(`value`: Output<String>) {
        this.timeWindowSize = value
    }

    /**
     * @param value Status of the custom alert.
     */
    @JvmName("nojncqabjsxjxjpe")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The maximum threshold.
     */
    @JvmName("qxlfnyyjxgpmbsxc")
    public suspend fun maxThreshold(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxThreshold = mapped
    }

    /**
     * @param value The minimum threshold.
     */
    @JvmName("dkmbwrcymbbntpoq")
    public suspend fun minThreshold(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minThreshold = mapped
    }

    /**
     * @param value The type of the custom alert rule.
     * Expected value is 'TimeWindowCustomAlertRule'.
     */
    @JvmName("pbklpbpfxqekascf")
    public suspend fun ruleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value The time window size in iso8601 format.
     */
    @JvmName("mwvqoggcvmeuajph")
    public suspend fun timeWindowSize(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeWindowSize = mapped
    }

    internal fun build(): TimeWindowCustomAlertRuleArgs = TimeWindowCustomAlertRuleArgs(
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        maxThreshold = maxThreshold ?: throw PulumiNullFieldException("maxThreshold"),
        minThreshold = minThreshold ?: throw PulumiNullFieldException("minThreshold"),
        ruleType = ruleType ?: throw PulumiNullFieldException("ruleType"),
        timeWindowSize = timeWindowSize ?: throw PulumiNullFieldException("timeWindowSize"),
    )
}
