@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.VmRecommendationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a machine that is part of a machine group
 * @property configurationStatus The configuration status of the machines group or machine or rule
 * @property enforcementSupport The machine supportability of Enforce feature
 * @property recommendationAction The recommendation action of the machine or rule
 * @property resourceId The full resource id of the machine
 */
public data class VmRecommendationArgs(
    public val configurationStatus: Output<String>? = null,
    public val enforcementSupport: Output<String>? = null,
    public val recommendationAction: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.VmRecommendationArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.VmRecommendationArgs =
        com.pulumi.azurenative.security.inputs.VmRecommendationArgs.builder()
            .configurationStatus(configurationStatus?.applyValue({ args0 -> args0 }))
            .enforcementSupport(enforcementSupport?.applyValue({ args0 -> args0 }))
            .recommendationAction(recommendationAction?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VmRecommendationArgs].
 */
@PulumiTagMarker
public class VmRecommendationArgsBuilder internal constructor() {
    private var configurationStatus: Output<String>? = null

    private var enforcementSupport: Output<String>? = null

    private var recommendationAction: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value The configuration status of the machines group or machine or rule
     */
    @JvmName("kkrgbuymmywtpvut")
    public suspend fun configurationStatus(`value`: Output<String>) {
        this.configurationStatus = value
    }

    /**
     * @param value The machine supportability of Enforce feature
     */
    @JvmName("nkfiugcoyyibujmu")
    public suspend fun enforcementSupport(`value`: Output<String>) {
        this.enforcementSupport = value
    }

    /**
     * @param value The recommendation action of the machine or rule
     */
    @JvmName("uwjjotwowlkgximn")
    public suspend fun recommendationAction(`value`: Output<String>) {
        this.recommendationAction = value
    }

    /**
     * @param value The full resource id of the machine
     */
    @JvmName("atbkycojhhkdrqws")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The configuration status of the machines group or machine or rule
     */
    @JvmName("fmbdmclnworecnhb")
    public suspend fun configurationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationStatus = mapped
    }

    /**
     * @param value The machine supportability of Enforce feature
     */
    @JvmName("wxsnbvguctxapfty")
    public suspend fun enforcementSupport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforcementSupport = mapped
    }

    /**
     * @param value The recommendation action of the machine or rule
     */
    @JvmName("xqywxosnlahwhywg")
    public suspend fun recommendationAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recommendationAction = mapped
    }

    /**
     * @param value The full resource id of the machine
     */
    @JvmName("cqdyaicjlameceox")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): VmRecommendationArgs = VmRecommendationArgs(
        configurationStatus = configurationStatus,
        enforcementSupport = enforcementSupport,
        recommendationAction = recommendationAction,
        resourceId = resourceId,
    )
}
