@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The target Event Hub to which event data will be exported. To learn more about Microsoft Defender for Cloud continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
 * @property actionType The type of the action that will be triggered by the Automation
 * Expected value is 'EventHub'.
 * @property connectionString The target Event Hub connection string (it will not be included in any response).
 * @property eventHubResourceId The target Event Hub Azure Resource ID.
 * @property sasPolicyName The target Event Hub SAS policy name.
 */
public data class AutomationActionEventHubResponse(
    public val actionType: String,
    public val connectionString: String? = null,
    public val eventHubResourceId: String? = null,
    public val sasPolicyName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AutomationActionEventHubResponse): AutomationActionEventHubResponse = AutomationActionEventHubResponse(
            actionType = javaType.actionType(),
            connectionString = javaType.connectionString().map({ args0 -> args0 }).orElse(null),
            eventHubResourceId = javaType.eventHubResourceId().map({ args0 -> args0 }).orElse(null),
            sasPolicyName = javaType.sasPolicyName(),
        )
    }
}
