@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The logic app action that should be triggered. To learn more about Microsoft Defender for Cloud's Workflow Automation capabilities, visit https://aka.ms/ASCWorkflowAutomationLearnMore
 * @property actionType The type of the action that will be triggered by the Automation
 * Expected value is 'LogicApp'.
 * @property logicAppResourceId The triggered Logic App Azure Resource ID. This can also reside on other subscriptions, given that you have permissions to trigger the Logic App
 * @property uri The Logic App trigger URI endpoint (it will not be included in any response).
 */
public data class AutomationActionLogicAppResponse(
    public val actionType: String,
    public val logicAppResourceId: String? = null,
    public val uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AutomationActionLogicAppResponse): AutomationActionLogicAppResponse = AutomationActionLogicAppResponse(
            actionType = javaType.actionType(),
            logicAppResourceId = javaType.logicAppResourceId().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
