@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * A rule set which evaluates all its rules upon an event interception. Only when all the included rules in the rule set will be evaluated as 'true', will the event trigger the defined actions.
 * @property rules
 */
public data class AutomationRuleSetResponse(
    public val rules: List<AutomationTriggeringRuleResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AutomationRuleSetResponse): AutomationRuleSetResponse = AutomationRuleSetResponse(
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.AutomationTriggeringRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
