@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A single automation scope.
 * @property description The resources scope description.
 * @property scopePath The resources scope path. Can be the subscription on which the automation is defined on or a resource group under that subscription (fully qualified Azure resource IDs).
 */
public data class AutomationScopeResponse(
    public val description: String? = null,
    public val scopePath: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AutomationScopeResponse): AutomationScopeResponse = AutomationScopeResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            scopePath = javaType.scopePath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
