@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The source event types which evaluate the security automation set of rules. For example - security alerts and security assessments. To learn more about the supported security events data models schemas - please visit https://aka.ms/ASCAutomationSchemas.
 * @property eventSource A valid event source type.
 * @property ruleSets A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
 */
public data class AutomationSourceResponse(
    public val eventSource: String? = null,
    public val ruleSets: List<AutomationRuleSetResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AutomationSourceResponse): AutomationSourceResponse = AutomationSourceResponse(
            eventSource = javaType.eventSource().map({ args0 -> args0 }).orElse(null),
            ruleSets = javaType.ruleSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.AutomationRuleSetResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
