@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * AWS cloud account connector based credentials, the credentials is composed of access key ID and secret key, for more details, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_create.html">Creating an IAM User in Your AWS Account (write only)</a>
 * @property accountId The ID of the cloud account
 * @property authenticationProvisioningState State of the multi-cloud connector
 * @property authenticationType Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
 * Expected value is 'awsCreds'.
 * @property awsAccessKeyId Public key element of the AWS credential object (write only)
 * @property awsSecretAccessKey Secret key element of the AWS credential object (write only)
 * @property grantedPermissions The permissions detected in the cloud account.
 */
public data class AwsCredsAuthenticationDetailsPropertiesResponse(
    public val accountId: String,
    public val authenticationProvisioningState: String,
    public val authenticationType: String,
    public val awsAccessKeyId: String,
    public val awsSecretAccessKey: String,
    public val grantedPermissions: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AwsCredsAuthenticationDetailsPropertiesResponse): AwsCredsAuthenticationDetailsPropertiesResponse =
            AwsCredsAuthenticationDetailsPropertiesResponse(
                accountId = javaType.accountId(),
                authenticationProvisioningState = javaType.authenticationProvisioningState(),
                authenticationType = javaType.authenticationType(),
                awsAccessKeyId = javaType.awsAccessKeyId(),
                awsSecretAccessKey = javaType.awsSecretAccessKey(),
                grantedPermissions = javaType.grantedPermissions().map({ args0 -> args0 }),
            )
    }
}
