@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The AWS connector environment data
 * @property accountName The AWS account name
 * @property environmentType The type of the environment data.
 * Expected value is 'AwsAccount'.
 * @property organizationalData The AWS account's organizational data
 * @property regions list of regions to scan
 */
public data class AwsEnvironmentDataResponse(
    public val accountName: String,
    public val environmentType: String,
    public val organizationalData: Either<AwsOrganizationalDataMasterResponse, AwsOrganizationalDataMemberResponse>? = null,
    public val regions: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AwsEnvironmentDataResponse): AwsEnvironmentDataResponse = AwsEnvironmentDataResponse(
            accountName = javaType.accountName(),
            environmentType = javaType.environmentType(),
            organizationalData = javaType.organizationalData().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.security.kotlin.outputs.AwsOrganizationalDataMasterResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.security.kotlin.outputs.AwsOrganizationalDataMemberResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            regions = javaType.regions().map({ args0 -> args0 }),
        )
    }
}
