@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the Azure resource that was assessed
 * @property id Azure resource Id of the assessed resource
 * @property source The platform where the assessed resource resides
 * Expected value is 'Azure'.
 */
public data class AzureResourceDetailsResponse(
    public val id: String,
    public val source: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AzureResourceDetailsResponse): AzureResourceDetailsResponse = AzureResourceDetailsResponse(
            id = javaType.id(),
            source = javaType.source(),
        )
    }
}
