@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The CSPM monitoring for AWS offering
 * @property description The offering description.
 * @property nativeCloudConnection The native cloud connection configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'CspmMonitorAws'.
 */
public data class CspmMonitorAwsOfferingResponse(
    public val description: String,
    public val nativeCloudConnection: CspmMonitorAwsOfferingResponseNativeCloudConnection? = null,
    public val offeringType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.CspmMonitorAwsOfferingResponse): CspmMonitorAwsOfferingResponse = CspmMonitorAwsOfferingResponse(
            description = javaType.description(),
            nativeCloudConnection = javaType.nativeCloudConnection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.CspmMonitorAwsOfferingResponseNativeCloudConnection.Companion.toKotlin(args0)
                })
            }).orElse(null),
            offeringType = javaType.offeringType(),
        )
    }
}
