@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The CSPM monitoring for GCP offering
 * @property description The offering description.
 * @property nativeCloudConnection The native cloud connection configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'CspmMonitorGcp'.
 */
public data class CspmMonitorGcpOfferingResponse(
    public val description: String,
    public val nativeCloudConnection: CspmMonitorGcpOfferingResponseNativeCloudConnection? = null,
    public val offeringType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.CspmMonitorGcpOfferingResponse): CspmMonitorGcpOfferingResponse = CspmMonitorGcpOfferingResponse(
            description = javaType.description(),
            nativeCloudConnection = javaType.nativeCloudConnection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.CspmMonitorGcpOfferingResponseNativeCloudConnection.Companion.toKotlin(args0)
                })
            }).orElse(null),
            offeringType = javaType.offeringType(),
        )
    }
}
