@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The CSPM (Cloud security posture management) monitoring for gitlab offering
 * @property description The offering description.
 * @property offeringType The type of the security offering.
 * Expected value is 'CspmMonitorGitLab'.
 */
public data class CspmMonitorGitLabOfferingResponse(
    public val description: String,
    public val offeringType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.CspmMonitorGitLabOfferingResponse): CspmMonitorGitLabOfferingResponse = CspmMonitorGitLabOfferingResponse(
            description = javaType.description(),
            offeringType = javaType.offeringType(),
        )
    }
}
