@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The CSPM monitoring for github offering
 * @property description The offering description.
 * @property offeringType The type of the security offering.
 * Expected value is 'CspmMonitorGithub'.
 */
public data class CspmMonitorGithubOfferingResponse(
    public val description: String,
    public val offeringType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.CspmMonitorGithubOfferingResponse): CspmMonitorGithubOfferingResponse = CspmMonitorGithubOfferingResponse(
            description = javaType.description(),
            offeringType = javaType.offeringType(),
        )
    }
}
