@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The CSPM P1 for GCP offering
 * @property description The offering description.
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderCspmGcp'.
 */
public data class DefenderCspmGcpOfferingResponse(
    public val description: String,
    public val offeringType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderCspmGcpOfferingResponse): DefenderCspmGcpOfferingResponse = DefenderCspmGcpOfferingResponse(
            description = javaType.description(),
            offeringType = javaType.offeringType(),
        )
    }
}
