@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The Defender for Containers AWS offering
 * @property autoProvisioning Is audit logs pipeline auto provisioning enabled
 * @property cloudWatchToKinesis The cloudwatch to kinesis connection configuration
 * @property containerVulnerabilityAssessment The container vulnerability assessment configuration
 * @property containerVulnerabilityAssessmentTask The container vulnerability assessment task configuration
 * @property description The offering description.
 * @property enableContainerVulnerabilityAssessment Enable container vulnerability assessment feature
 * @property kinesisToS3 The kinesis to s3 connection configuration
 * @property kubeAuditRetentionTime The retention time in days of kube audit logs set on the CloudWatch log group
 * @property kubernetesScubaReader The kubernetes to scuba connection configuration
 * @property kubernetesService The kubernetes service connection configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForContainersAws'.
 * @property scubaExternalId The externalId used by the data reader to prevent the confused deputy attack
 */
public data class DefenderForContainersAwsOfferingResponse(
    public val autoProvisioning: Boolean? = null,
    public val cloudWatchToKinesis: DefenderForContainersAwsOfferingResponseCloudWatchToKinesis? =
        null,
    public val containerVulnerabilityAssessment: DefenderForContainersAwsOfferingResponseContainerVulnerabilityAssessment? = null,
    public val containerVulnerabilityAssessmentTask: DefenderForContainersAwsOfferingResponseContainerVulnerabilityAssessmentTask? = null,
    public val description: String,
    public val enableContainerVulnerabilityAssessment: Boolean? = null,
    public val kinesisToS3: DefenderForContainersAwsOfferingResponseKinesisToS3? = null,
    public val kubeAuditRetentionTime: Double? = null,
    public val kubernetesScubaReader: DefenderForContainersAwsOfferingResponseKubernetesScubaReader? =
        null,
    public val kubernetesService: DefenderForContainersAwsOfferingResponseKubernetesService? = null,
    public val offeringType: String,
    public val scubaExternalId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForContainersAwsOfferingResponse): DefenderForContainersAwsOfferingResponse = DefenderForContainersAwsOfferingResponse(
            autoProvisioning = javaType.autoProvisioning().map({ args0 -> args0 }).orElse(null),
            cloudWatchToKinesis = javaType.cloudWatchToKinesis().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForContainersAwsOfferingResponseCloudWatchToKinesis.Companion.toKotlin(args0)
                })
            }).orElse(null),
            containerVulnerabilityAssessment = javaType.containerVulnerabilityAssessment().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForContainersAwsOfferingResponseContainerVulnerabilityAssessment.Companion.toKotlin(args0)
                })
            }).orElse(null),
            containerVulnerabilityAssessmentTask = javaType.containerVulnerabilityAssessmentTask().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForContainersAwsOfferingResponseContainerVulnerabilityAssessmentTask.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description(),
            enableContainerVulnerabilityAssessment = javaType.enableContainerVulnerabilityAssessment().map({ args0 ->
                args0
            }).orElse(null),
            kinesisToS3 = javaType.kinesisToS3().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForContainersAwsOfferingResponseKinesisToS3.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kubeAuditRetentionTime = javaType.kubeAuditRetentionTime().map({ args0 -> args0 }).orElse(null),
            kubernetesScubaReader = javaType.kubernetesScubaReader().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForContainersAwsOfferingResponseKubernetesScubaReader.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kubernetesService = javaType.kubernetesService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForContainersAwsOfferingResponseKubernetesService.Companion.toKotlin(args0)
                })
            }).orElse(null),
            offeringType = javaType.offeringType(),
            scubaExternalId = javaType.scubaExternalId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
