@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The containers GCP offering
 * @property auditLogsAutoProvisioningFlag Is audit logs data collection enabled
 * @property dataPipelineNativeCloudConnection The native cloud connection configuration
 * @property defenderAgentAutoProvisioningFlag Is Microsoft Defender for Cloud Kubernetes agent auto provisioning enabled
 * @property description The offering description.
 * @property nativeCloudConnection The native cloud connection configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForContainersGcp'.
 * @property policyAgentAutoProvisioningFlag Is Policy Kubernetes agent auto provisioning enabled
 */
public data class DefenderForContainersGcpOfferingResponse(
    public val auditLogsAutoProvisioningFlag: Boolean? = null,
    public val dataPipelineNativeCloudConnection: DefenderForContainersGcpOfferingResponseDataPipelineNativeCloudConnection? = null,
    public val defenderAgentAutoProvisioningFlag: Boolean? = null,
    public val description: String,
    public val nativeCloudConnection: DefenderForContainersGcpOfferingResponseNativeCloudConnection? =
        null,
    public val offeringType: String,
    public val policyAgentAutoProvisioningFlag: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForContainersGcpOfferingResponse): DefenderForContainersGcpOfferingResponse = DefenderForContainersGcpOfferingResponse(
            auditLogsAutoProvisioningFlag = javaType.auditLogsAutoProvisioningFlag().map({ args0 ->
                args0
            }).orElse(null),
            dataPipelineNativeCloudConnection = javaType.dataPipelineNativeCloudConnection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForContainersGcpOfferingResponseDataPipelineNativeCloudConnection.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defenderAgentAutoProvisioningFlag = javaType.defenderAgentAutoProvisioningFlag().map({ args0 ->
                args0
            }).orElse(null),
            description = javaType.description(),
            nativeCloudConnection = javaType.nativeCloudConnection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DefenderForContainersGcpOfferingResponseNativeCloudConnection.Companion.toKotlin(args0)
                })
            }).orElse(null),
            offeringType = javaType.offeringType(),
            policyAgentAutoProvisioningFlag = javaType.policyAgentAutoProvisioningFlag().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
