@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Defender for DevOps for Azure DevOps offering
 * @property description The offering description.
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForDevOpsAzureDevOps'.
 */
public data class DefenderForDevOpsAzureDevOpsOfferingResponse(
    public val description: String,
    public val offeringType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForDevOpsAzureDevOpsOfferingResponse): DefenderForDevOpsAzureDevOpsOfferingResponse = DefenderForDevOpsAzureDevOpsOfferingResponse(
            description = javaType.description(),
            offeringType = javaType.offeringType(),
        )
    }
}
