@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Defender for DevOps for Gitlab offering
 * @property description The offering description.
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForDevOpsGitLab'.
 */
public data class DefenderForDevOpsGitLabOfferingResponse(
    public val description: String,
    public val offeringType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForDevOpsGitLabOfferingResponse): DefenderForDevOpsGitLabOfferingResponse = DefenderForDevOpsGitLabOfferingResponse(
            description = javaType.description(),
            offeringType = javaType.offeringType(),
        )
    }
}
