@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Defender for DevOps for Github offering
 * @property description The offering description.
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForDevOpsGithub'.
 */
public data class DefenderForDevOpsGithubOfferingResponse(
    public val description: String,
    public val offeringType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForDevOpsGithubOfferingResponse): DefenderForDevOpsGithubOfferingResponse = DefenderForDevOpsGithubOfferingResponse(
            description = javaType.description(),
            offeringType = javaType.offeringType(),
        )
    }
}
