@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The Microsoft Defender for Server VM scanning configuration
 * @property configuration configuration for Microsoft Defender for Server VM scanning
 * @property enabled Is Microsoft Defender for Server VM scanning enabled
 */
public data class DefenderForServersAwsOfferingResponseVmScanners(
    public val configuration: DefenderForServersAwsOfferingResponseConfigurationConfigurationConfiguration? = null,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForServersAwsOfferingResponseVmScanners): DefenderForServersAwsOfferingResponseVmScanners =
            DefenderForServersAwsOfferingResponseVmScanners(
                configuration = javaType.configuration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersAwsOfferingResponseConfigurationConfigurationConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
