@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The ARC autoprovisioning configuration
 * @property configuration Configuration for servers Arc auto provisioning
 * @property enabled Is arc auto provisioning enabled
 */
public data class DefenderForServersGcpOfferingResponseArcAutoProvisioning(
    public val configuration: DefenderForServersGcpOfferingResponseConfiguration? = null,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForServersGcpOfferingResponseArcAutoProvisioning): DefenderForServersGcpOfferingResponseArcAutoProvisioning =
            DefenderForServersGcpOfferingResponseArcAutoProvisioning(
                configuration = javaType.configuration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersGcpOfferingResponseConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
