@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A custom alert rule that checks if a value (depends on the custom alert type) is denied.
 * @property denylistValues The values to deny. The format of the values depends on the rule type.
 * @property description The description of the custom alert.
 * @property displayName The display name of the custom alert.
 * @property isEnabled Status of the custom alert.
 * @property ruleType The type of the custom alert rule.
 * Expected value is 'DenylistCustomAlertRule'.
 * @property valueType The value type of the items in the list.
 */
public data class DenylistCustomAlertRuleResponse(
    public val denylistValues: List<String>,
    public val description: String,
    public val displayName: String,
    public val isEnabled: Boolean,
    public val ruleType: String,
    public val valueType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DenylistCustomAlertRuleResponse): DenylistCustomAlertRuleResponse = DenylistCustomAlertRuleResponse(
            denylistValues = javaType.denylistValues().map({ args0 -> args0 }),
            description = javaType.description(),
            displayName = javaType.displayName(),
            isEnabled = javaType.isEnabled(),
            ruleType = javaType.ruleType(),
            valueType = javaType.valueType(),
        )
    }
}
