@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the DevOps policy assignment resource.
 * @property assignedAt Gets or sets time when the assignment was created in UTC.
 * @property descendantBehavior The behavior of a policy on descendant resources.
 * @property policy Condensed information to identify a DevOps Policy resource.
 * @property provisioningState The provisioning state of the resource.
 * Pending - Provisioning pending.
 * Failed - Provisioning failed.
 * Succeeded - Successful provisioning.
 * Canceled - Provisioning canceled.
 * PendingDeletion - Deletion pending.
 * DeletionSuccess - Deletion successful.
 * DeletionFailure - Deletion failure.
 * @property provisioningStatusMessage Gets the resource status message.
 * @property provisioningStatusUpdateTimeUtc Gets the time when resource was last checked.
 * @property resourceId Gets or sets the Azure resource id.
 */
public data class DevOpsPolicyAssignmentPropertiesResponse(
    public val assignedAt: String? = null,
    public val descendantBehavior: String? = null,
    public val policy: DevOpsPolicyDescriptorResponse? = null,
    public val provisioningState: String,
    public val provisioningStatusMessage: String,
    public val provisioningStatusUpdateTimeUtc: String,
    public val resourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DevOpsPolicyAssignmentPropertiesResponse): DevOpsPolicyAssignmentPropertiesResponse = DevOpsPolicyAssignmentPropertiesResponse(
            assignedAt = javaType.assignedAt().map({ args0 -> args0 }).orElse(null),
            descendantBehavior = javaType.descendantBehavior().map({ args0 -> args0 }).orElse(null),
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DevOpsPolicyDescriptorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            provisioningStatusMessage = javaType.provisioningStatusMessage(),
            provisioningStatusUpdateTimeUtc = javaType.provisioningStatusUpdateTimeUtc(),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
