@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Condensed information to identify a DevOps Policy resource.
 * @property policyId Gets or sets the policy GUID.
 * @property policyName Gets or sets the policy name.
 * @property policyType DevOps Policy resource types.
 * @property policyVersion Gets or sets the version.
 */
public data class DevOpsPolicyDescriptorResponse(
    public val policyId: String? = null,
    public val policyName: String? = null,
    public val policyType: String? = null,
    public val policyVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DevOpsPolicyDescriptorResponse): DevOpsPolicyDescriptorResponse = DevOpsPolicyDescriptorResponse(
            policyId = javaType.policyId().map({ args0 -> args0 }).orElse(null),
            policyName = javaType.policyName().map({ args0 -> args0 }).orElse(null),
            policyType = javaType.policyType().map({ args0 -> args0 }).orElse(null),
            policyVersion = javaType.policyVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
