@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * A plan's extension properties
 * @property additionalExtensionProperties Property values associated with the extension.
 * @property isEnabled Indicates whether the extension is enabled.
 * @property name The extension name. Supported values are: <br><br>**AgentlessDiscoveryForKubernetes** - API-based discovery of information about Kubernetes cluster architecture, workload objects, and setup. Required for Kubernetes inventory, identity and network exposure detection, attack path analysis and risk hunting as part of the cloud security explorer.
 * Available for CloudPosture plan.<br><br>**OnUploadMalwareScanning** - Limits the GB to be scanned per month for each storage account within the subscription. Once this limit reached on a given storage account, Blobs won't be scanned during current calendar month.
 * Available for StorageAccounts plan.<br><br>**SensitiveDataDiscovery** - Sensitive data discovery identifies Blob storage container with sensitive data such as credentials, credit cards, and more, to help prioritize and investigate security events.
 * Available for StorageAccounts and CloudPosture plans.<br><br>**ContainerRegistriesVulnerabilityAssessments** - Provides vulnerability management for images stored in your container registries.
 * Available for CloudPosture and Containers plans.
 * @property operationStatus Optional. A status describing the success/failure of the extension's enablement/disablement operation.
 */
public data class ExtensionResponse(
    public val additionalExtensionProperties: Any? = null,
    public val isEnabled: String,
    public val name: String,
    public val operationStatus: OperationStatusResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.ExtensionResponse): ExtensionResponse = ExtensionResponse(
            additionalExtensionProperties = javaType.additionalExtensionProperties().map({ args0 ->
                args0
            }).orElse(null),
            isEnabled = javaType.isEnabled(),
            name = javaType.name(),
            operationStatus = javaType.operationStatus().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.OperationStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
