@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * GCP cloud account connector based service to service credentials, the credentials are composed of the organization ID and a JSON API key (write only)
 * @property authProviderX509CertUrl Auth provider x509 certificate URL field of the API key (write only)
 * @property authUri Auth URI field of the API key (write only)
 * @property authenticationProvisioningState State of the multi-cloud connector
 * @property authenticationType Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
 * Expected value is 'gcpCredentials'.
 * @property clientEmail Client email field of the API key (write only)
 * @property clientId Client ID field of the API key (write only)
 * @property clientX509CertUrl Client x509 certificate URL field of the API key (write only)
 * @property grantedPermissions The permissions detected in the cloud account.
 * @property organizationId The organization ID of the GCP cloud account
 * @property privateKey Private key field of the API key (write only)
 * @property privateKeyId Private key ID field of the API key (write only)
 * @property projectId Project ID field of the API key (write only)
 * @property tokenUri Token URI field of the API key (write only)
 * @property type Type field of the API key (write only)
 */
public data class GcpCredentialsDetailsPropertiesResponse(
    public val authProviderX509CertUrl: String,
    public val authUri: String,
    public val authenticationProvisioningState: String,
    public val authenticationType: String,
    public val clientEmail: String,
    public val clientId: String,
    public val clientX509CertUrl: String,
    public val grantedPermissions: List<String>,
    public val organizationId: String,
    public val privateKey: String,
    public val privateKeyId: String,
    public val projectId: String,
    public val tokenUri: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GcpCredentialsDetailsPropertiesResponse): GcpCredentialsDetailsPropertiesResponse = GcpCredentialsDetailsPropertiesResponse(
            authProviderX509CertUrl = javaType.authProviderX509CertUrl(),
            authUri = javaType.authUri(),
            authenticationProvisioningState = javaType.authenticationProvisioningState(),
            authenticationType = javaType.authenticationType(),
            clientEmail = javaType.clientEmail(),
            clientId = javaType.clientId(),
            clientX509CertUrl = javaType.clientX509CertUrl(),
            grantedPermissions = javaType.grantedPermissions().map({ args0 -> args0 }),
            organizationId = javaType.organizationId(),
            privateKey = javaType.privateKey(),
            privateKeyId = javaType.privateKeyId(),
            projectId = javaType.projectId(),
            tokenUri = javaType.tokenUri(),
            type = javaType.type(),
        )
    }
}
