@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The gcpOrganization data for the parent account
 * @property excludedProjectNumbers If the multi cloud account is of membership type organization, list of accounts excluded from offering
 * @property organizationMembershipType The multi cloud account's membership type in the organization
 * Expected value is 'Organization'.
 * @property organizationName GCP organization name
 * @property serviceAccountEmailAddress The service account email address which represents the organization level permissions container.
 * @property workloadIdentityProviderId The GCP workload identity provider id which represents the permissions required to auto provision security connectors
 */
public data class GcpOrganizationalDataOrganizationResponse(
    public val excludedProjectNumbers: List<String>? = null,
    public val organizationMembershipType: String,
    public val organizationName: String,
    public val serviceAccountEmailAddress: String? = null,
    public val workloadIdentityProviderId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GcpOrganizationalDataOrganizationResponse): GcpOrganizationalDataOrganizationResponse = GcpOrganizationalDataOrganizationResponse(
            excludedProjectNumbers = javaType.excludedProjectNumbers().map({ args0 -> args0 }),
            organizationMembershipType = javaType.organizationMembershipType(),
            organizationName = javaType.organizationName(),
            serviceAccountEmailAddress = javaType.serviceAccountEmailAddress().map({ args0 ->
                args0
            }).orElse(null),
            workloadIdentityProviderId = javaType.workloadIdentityProviderId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
