@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The details about the project represented by the security connector
 * @property projectId The GCP Project id
 * @property projectName GCP project name
 * @property projectNumber The unique GCP Project number
 * @property workloadIdentityPoolId The GCP workload identity federation pool id
 */
public data class GcpProjectDetailsResponse(
    public val projectId: String? = null,
    public val projectName: String,
    public val projectNumber: String? = null,
    public val workloadIdentityPoolId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GcpProjectDetailsResponse): GcpProjectDetailsResponse = GcpProjectDetailsResponse(
            projectId = javaType.projectId().map({ args0 -> args0 }).orElse(null),
            projectName = javaType.projectName(),
            projectNumber = javaType.projectNumber().map({ args0 -> args0 }).orElse(null),
            workloadIdentityPoolId = javaType.workloadIdentityPoolId(),
        )
    }
}
