@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * An API collection as represented by Microsoft Defender for APIs.
 * @property baseUrl The base URI for this API collection. All endpoints of this API collection extend this base URI.
 * @property discoveredVia The resource Id of the resource from where this API collection was discovered.
 * @property displayName The display name of the API collection.
 * @property id Resource Id
 * @property name Resource name
 * @property numberOfApiEndpoints The number of API endpoints discovered in this API collection.
 * @property numberOfApiEndpointsWithSensitiveDataExposed The number of API endpoints in this API collection which are exposing sensitive data in their requests and/or responses.
 * @property numberOfExternalApiEndpoints The number of API endpoints in this API collection for which API traffic from the internet was observed.
 * @property numberOfInactiveApiEndpoints The number of API endpoints in this API collection that have not received any API traffic in the last 30 days.
 * @property numberOfUnauthenticatedApiEndpoints The number of API endpoints in this API collection that are unauthenticated.
 * @property provisioningState Gets the provisioning state of the API collection.
 * @property sensitivityLabel The highest priority sensitivity label from Microsoft Purview in this API collection.
 * @property type Resource type
 */
public data class GetAPICollectionByAzureApiManagementServiceResult(
    public val baseUrl: String,
    public val discoveredVia: String,
    public val displayName: String,
    public val id: String,
    public val name: String,
    public val numberOfApiEndpoints: Double,
    public val numberOfApiEndpointsWithSensitiveDataExposed: Double,
    public val numberOfExternalApiEndpoints: Double,
    public val numberOfInactiveApiEndpoints: Double,
    public val numberOfUnauthenticatedApiEndpoints: Double,
    public val provisioningState: String,
    public val sensitivityLabel: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetAPICollectionByAzureApiManagementServiceResult): GetAPICollectionByAzureApiManagementServiceResult =
            GetAPICollectionByAzureApiManagementServiceResult(
                baseUrl = javaType.baseUrl(),
                discoveredVia = javaType.discoveredVia(),
                displayName = javaType.displayName(),
                id = javaType.id(),
                name = javaType.name(),
                numberOfApiEndpoints = javaType.numberOfApiEndpoints(),
                numberOfApiEndpointsWithSensitiveDataExposed = javaType.numberOfApiEndpointsWithSensitiveDataExposed(),
                numberOfExternalApiEndpoints = javaType.numberOfExternalApiEndpoints(),
                numberOfInactiveApiEndpoints = javaType.numberOfInactiveApiEndpoints(),
                numberOfUnauthenticatedApiEndpoints = javaType.numberOfUnauthenticatedApiEndpoints(),
                provisioningState = javaType.provisioningState(),
                sensitivityLabel = javaType.sensitivityLabel(),
                type = javaType.type(),
            )
    }
}
