@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The Advanced Threat Protection resource.
 * @property id Resource Id
 * @property isEnabled Indicates whether Advanced Threat Protection is enabled.
 * @property name Resource name
 * @property type Resource type
 */
public data class GetAdvancedThreatProtectionResult(
    public val id: String,
    public val isEnabled: Boolean? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetAdvancedThreatProtectionResult): GetAdvancedThreatProtectionResult = GetAdvancedThreatProtectionResult(
            id = javaType.id(),
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
