@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the suppression rule
 * @property alertType Type of the alert to automatically suppress. For all alert types, use '*'
 * @property comment Any comment regarding the rule
 * @property expirationDateUtc Expiration date of the rule, if value is not provided or provided as null there will no expiration at all
 * @property id Resource Id
 * @property lastModifiedUtc The last time this rule was modified
 * @property name Resource name
 * @property reason The reason for dismissing the alert
 * @property state Possible states of the rule
 * @property suppressionAlertsScope The suppression conditions
 * @property type Resource type
 */
public data class GetAlertsSuppressionRuleResult(
    public val alertType: String,
    public val comment: String? = null,
    public val expirationDateUtc: String? = null,
    public val id: String,
    public val lastModifiedUtc: String,
    public val name: String,
    public val reason: String,
    public val state: String,
    public val suppressionAlertsScope: SuppressionAlertsScopeResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetAlertsSuppressionRuleResult): GetAlertsSuppressionRuleResult = GetAlertsSuppressionRuleResult(
            alertType = javaType.alertType(),
            comment = javaType.comment().map({ args0 -> args0 }).orElse(null),
            expirationDateUtc = javaType.expirationDateUtc().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastModifiedUtc = javaType.lastModifiedUtc(),
            name = javaType.name(),
            reason = javaType.reason(),
            state = javaType.state(),
            suppressionAlertsScope = javaType.suppressionAlertsScope().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.SuppressionAlertsScopeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
