@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Security Application over a given scope
 * @property description description of the application
 * @property displayName display name of the application
 * @property id Resource Id
 * @property name Resource name
 * @property sourceResourceType The application source, what it affects, e.g. Assessments
 * @property type Resource type
 */
public data class GetApplicationResult(
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val name: String,
    public val sourceResourceType: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetApplicationResult): GetApplicationResult = GetApplicationResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            sourceResourceType = javaType.sourceResourceType(),
            type = javaType.type(),
        )
    }
}
