@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Security assessment on a resource - response format
 * @property additionalData Additional data regarding the assessment
 * @property displayName User friendly display name of the assessment
 * @property id Resource Id
 * @property links Links relevant to the assessment
 * @property metadata Describes properties of an assessment metadata.
 * @property name Resource name
 * @property partnersData Data regarding 3rd party partner integration
 * @property resourceDetails Details of the resource that was assessed
 * @property status The result of the assessment
 * @property type Resource type
 */
public data class GetAssessmentResult(
    public val additionalData: Map<String, String>? = null,
    public val displayName: String,
    public val id: String,
    public val links: AssessmentLinksResponse,
    public val metadata: SecurityAssessmentMetadataPropertiesResponse? = null,
    public val name: String,
    public val partnersData: SecurityAssessmentPartnerDataResponse? = null,
    public val resourceDetails: Any,
    public val status: AssessmentStatusResponseResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetAssessmentResult): GetAssessmentResult = GetAssessmentResult(
            additionalData = javaType.additionalData().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            displayName = javaType.displayName(),
            id = javaType.id(),
            links = javaType.links().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.AssessmentLinksResponse.Companion.toKotlin(args0)
            }),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.SecurityAssessmentMetadataPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            partnersData = javaType.partnersData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.SecurityAssessmentPartnerDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resourceDetails = javaType.resourceDetails(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.AssessmentStatusResponseResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
