@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Security Assignment on a resource group over a given scope
 * @property additionalData Additional data about the assignment
 * @property assignedComponent Component item with key as applied to this standard assignment over the given scope
 * @property assignedStandard Standard item with key as applied to this standard assignment over the given scope
 * @property description description of the standardAssignment
 * @property displayName display name of the standardAssignment
 * @property effect expected effect of this assignment (Disable/Exempt/etc)
 * @property etag Entity tag is used for comparing two or more entities from the same requested resource.
 * @property expiresOn Expiration date of this assignment as a full ISO date
 * @property id Resource Id
 * @property kind Kind of the resource
 * @property location Location where the resource is stored
 * @property metadata The assignment metadata. Metadata is an open ended object and is typically a collection of key value pairs.
 * @property name Resource name
 * @property scope Scope to which the standardAssignment applies - can be a subscription path or a resource group under that subscription
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags A list of key value pairs that describe the resource.
 * @property type Resource type
 */
public data class GetAssignmentResult(
    public val additionalData: AssignmentPropertiesResponseAdditionalData? = null,
    public val assignedComponent: AssignedComponentItemResponse? = null,
    public val assignedStandard: AssignedStandardItemResponse? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val effect: String? = null,
    public val etag: String? = null,
    public val expiresOn: String? = null,
    public val id: String,
    public val kind: String? = null,
    public val location: String? = null,
    public val metadata: Any? = null,
    public val name: String,
    public val scope: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetAssignmentResult): GetAssignmentResult = GetAssignmentResult(
            additionalData = javaType.additionalData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.AssignmentPropertiesResponseAdditionalData.Companion.toKotlin(args0)
                })
            }).orElse(null),
            assignedComponent = javaType.assignedComponent().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.AssignedComponentItemResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            assignedStandard = javaType.assignedStandard().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.AssignedStandardItemResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            effect = javaType.effect().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            expiresOn = javaType.expiresOn().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
