@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The connector setting
 * @property authenticationDetails Settings for authentication management, these settings are relevant only for the cloud connector.
 * @property hybridComputeSettings Settings for hybrid compute management. These settings are relevant only for Arc autoProvision (Hybrid Compute).
 * @property id Resource Id
 * @property name Resource name
 * @property type Resource type
 */
public data class GetConnectorResult(
    public val authenticationDetails: Any? = null,
    public val hybridComputeSettings: HybridComputeSettingsPropertiesResponse? = null,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetConnectorResult): GetConnectorResult = GetConnectorResult(
            authenticationDetails = javaType.authenticationDetails().map({ args0 -> args0 }).orElse(null),
            hybridComputeSettings = javaType.hybridComputeSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.HybridComputeSettingsPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
