@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The device security group resource
 * @property allowlistRules The allow-list custom alert rules.
 * @property denylistRules The deny-list custom alert rules.
 * @property id Resource Id
 * @property name Resource name
 * @property thresholdRules The list of custom alert threshold rules.
 * @property timeWindowRules The list of custom alert time-window rules.
 * @property type Resource type
 */
public data class GetDeviceSecurityGroupResult(
    public val allowlistRules: List<AllowlistCustomAlertRuleResponse>? = null,
    public val denylistRules: List<DenylistCustomAlertRuleResponse>? = null,
    public val id: String,
    public val name: String,
    public val thresholdRules: List<ThresholdCustomAlertRuleResponse>? = null,
    public val timeWindowRules: List<TimeWindowCustomAlertRuleResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetDeviceSecurityGroupResult): GetDeviceSecurityGroupResult = GetDeviceSecurityGroupResult(
            allowlistRules = javaType.allowlistRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.AllowlistCustomAlertRuleResponse.Companion.toKotlin(args0)
                })
            }),
            denylistRules = javaType.denylistRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.DenylistCustomAlertRuleResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            thresholdRules = javaType.thresholdRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.ThresholdCustomAlertRuleResponse.Companion.toKotlin(args0)
                })
            }),
            timeWindowRules = javaType.timeWindowRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.TimeWindowCustomAlertRuleResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
