@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Governance assignment over a given scope
 * @property additionalData The additional data for the governance assignment - e.g. links to ticket (optional), see example
 * @property governanceEmailNotification The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
 * @property id Resource Id
 * @property isGracePeriod Defines whether there is a grace period on the governance assignment
 * @property name Resource name
 * @property owner The Owner for the governance assignment - e.g. user@contoso.com - see example
 * @property remediationDueDate The remediation due-date - after this date Secure Score will be affected (in case of  active grace-period)
 * @property remediationEta The ETA (estimated time of arrival) for remediation (optional), see example
 * @property type Resource type
 */
public data class GetGovernanceAssignmentResult(
    public val additionalData: GovernanceAssignmentAdditionalDataResponse? = null,
    public val governanceEmailNotification: GovernanceEmailNotificationResponse? = null,
    public val id: String,
    public val isGracePeriod: Boolean? = null,
    public val name: String,
    public val owner: String? = null,
    public val remediationDueDate: String,
    public val remediationEta: RemediationEtaResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetGovernanceAssignmentResult): GetGovernanceAssignmentResult = GetGovernanceAssignmentResult(
            additionalData = javaType.additionalData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.GovernanceAssignmentAdditionalDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            governanceEmailNotification = javaType.governanceEmailNotification().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.GovernanceEmailNotificationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            isGracePeriod = javaType.isGracePeriod().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            owner = javaType.owner().map({ args0 -> args0 }).orElse(null),
            remediationDueDate = javaType.remediationDueDate(),
            remediationEta = javaType.remediationEta().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.RemediationEtaResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
