@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Governance rule over a given scope
 * @property description Description of the governance rule
 * @property displayName Display name of the governance rule
 * @property excludedScopes Excluded scopes, filter out the descendants of the scope (on management scopes)
 * @property governanceEmailNotification The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
 * @property id Resource Id
 * @property includeMemberScopes Defines whether the rule is management scope rule (master connector as a single scope or management scope)
 * @property isDisabled Defines whether the rule is active/inactive
 * @property isGracePeriod Defines whether there is a grace period on the governance rule
 * @property metadata The governance rule metadata
 * @property name Resource name
 * @property ownerSource The owner source for the governance rule - e.g. Manually by user@contoso.com - see example
 * @property remediationTimeframe Governance rule remediation timeframe - this is the time that will affect on the grace-period duration e.g. 7.00:00:00 - means 7 days
 * @property rulePriority The governance rule priority, priority to the lower number. Rules with the same priority on the same scope will not be allowed
 * @property ruleType The rule type of the governance rule, defines the source of the rule e.g. Integrated
 * @property sourceResourceType The governance rule source, what the rule affects, e.g. Assessments
 * @property tenantId The tenantId (GUID)
 * @property type Resource type
 */
public data class GetGovernanceRuleResult(
    public val description: String? = null,
    public val displayName: String,
    public val excludedScopes: List<String>? = null,
    public val governanceEmailNotification: GovernanceRuleEmailNotificationResponse? = null,
    public val id: String,
    public val includeMemberScopes: Boolean? = null,
    public val isDisabled: Boolean? = null,
    public val isGracePeriod: Boolean? = null,
    public val metadata: GovernanceRuleMetadataResponse? = null,
    public val name: String,
    public val ownerSource: GovernanceRuleOwnerSourceResponse,
    public val remediationTimeframe: String? = null,
    public val rulePriority: Int,
    public val ruleType: String,
    public val sourceResourceType: String,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetGovernanceRuleResult): GetGovernanceRuleResult = GetGovernanceRuleResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            excludedScopes = javaType.excludedScopes().map({ args0 -> args0 }),
            governanceEmailNotification = javaType.governanceEmailNotification().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.GovernanceRuleEmailNotificationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            includeMemberScopes = javaType.includeMemberScopes().map({ args0 -> args0 }).orElse(null),
            isDisabled = javaType.isDisabled().map({ args0 -> args0 }).orElse(null),
            isGracePeriod = javaType.isGracePeriod().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.GovernanceRuleMetadataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            ownerSource = javaType.ownerSource().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.GovernanceRuleOwnerSourceResponse.Companion.toKotlin(args0)
            }),
            remediationTimeframe = javaType.remediationTimeframe().map({ args0 -> args0 }).orElse(null),
            rulePriority = javaType.rulePriority(),
            ruleType = javaType.ruleType(),
            sourceResourceType = javaType.sourceResourceType(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
