@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * IoT Security solution configuration and resource information.
 * @property additionalWorkspaces List of additional workspaces
 * @property autoDiscoveredResources List of resources that were automatically discovered as relevant to the security solution.
 * @property disabledDataSources Disabled data sources. Disabling these data sources compromises the system.
 * @property displayName Resource display name.
 * @property export List of additional options for exporting to workspace data.
 * @property id Resource Id
 * @property iotHubs IoT Hub resource IDs
 * @property location The resource location.
 * @property name Resource name
 * @property recommendationsConfiguration List of the configuration status for each recommendation type.
 * @property status Status of the IoT Security solution.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags
 * @property type Resource type
 * @property unmaskedIpLoggingStatus Unmasked IP address logging status
 * @property userDefinedResources Properties of the IoT Security solution's user defined resources.
 * @property workspace Workspace resource ID
 */
public data class GetIotSecuritySolutionResult(
    public val additionalWorkspaces: List<AdditionalWorkspacesPropertiesResponse>? = null,
    public val autoDiscoveredResources: List<String>,
    public val disabledDataSources: List<String>? = null,
    public val displayName: String,
    public val export: List<String>? = null,
    public val id: String,
    public val iotHubs: List<String>,
    public val location: String? = null,
    public val name: String,
    public val recommendationsConfiguration: List<RecommendationConfigurationPropertiesResponse>? =
        null,
    public val status: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val unmaskedIpLoggingStatus: String? = null,
    public val userDefinedResources: UserDefinedResourcesPropertiesResponse? = null,
    public val workspace: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetIotSecuritySolutionResult): GetIotSecuritySolutionResult = GetIotSecuritySolutionResult(
            additionalWorkspaces = javaType.additionalWorkspaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.AdditionalWorkspacesPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            autoDiscoveredResources = javaType.autoDiscoveredResources().map({ args0 -> args0 }),
            disabledDataSources = javaType.disabledDataSources().map({ args0 -> args0 }),
            displayName = javaType.displayName(),
            export = javaType.export().map({ args0 -> args0 }),
            id = javaType.id(),
            iotHubs = javaType.iotHubs().map({ args0 -> args0 }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            recommendationsConfiguration = javaType.recommendationsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.RecommendationConfigurationPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            unmaskedIpLoggingStatus = javaType.unmaskedIpLoggingStatus().map({ args0 -> args0 }).orElse(null),
            userDefinedResources = javaType.userDefinedResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.UserDefinedResourcesPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workspace = javaType.workspace().map({ args0 -> args0 }).orElse(null),
        )
    }
}
